﻿using System.Collections.Generic;

namespace Framework.Web
{
    /// <summary>
    /// ポップアップ画面の画面スタイル
    /// </summary>
    public class WindowStyle
    {
        /// <summary>
        /// ウィンドウの幅。未指定の場合はブラウザまかせ
        /// </summary>
        public int Width = -1;

        /// <summary>
        /// ウィンドウの高さ。未指定の場合はブラウザまかせ
        /// </summary>
        public int Height = -1;

        /// <summary>
        /// ウィンドウの上部位置。未指定の場合はウィンドウが画面中央あたりにくる位置。
        /// </summary>
        public int Top = -1;

        /// <summary>
        /// ウィンドウの左位置。未指定の場合はウィンドウが画面中央あたりにくる位置。
        /// </summary>
        public int Left = -1;

        /// <summary>
        /// ToolBarの有無
        /// </summary>
        public bool ToolBar = false;

        /// <summary>
        /// Locationの有無
        /// </summary>
        public bool Location = false;

        /// <summary>
        /// Directoriesの有無
        /// </summary>
        public bool Directories = false;

        /// <summary>
        /// Statusの有無
        /// </summary>
        public bool Status = false;

        /// <summary>
        /// MenuBarの有無
        /// </summary>
        public bool MenuBar = false;

        /// <summary>
        /// Scrollbarsの有無
        /// </summary>
        public bool Scrollbars = false;

        /// <summary>
        /// サイズ変更可能か。
        /// </summary>
        public bool Resizable = true;

        /// <summary>
        /// trueの場合は、同じ名前の画面が開いている場合でも新しくつくりなおす。
        /// </summary>
        public bool NoCache = false;

        public WindowStyle()
        {
        }

        public WindowStyle(int width, int height)
        {
            Width = width;
            Height = height;
        }

        /// <summary>
        /// Window.Openに指定するwindowstyleの文字列を返します。
        /// </summary>
        /// <returns></returns>
        public string GetStyle()
        {
            var style = new List<string>();

            if (Width > 0) style.Add(string.Format("width={0}", Width));
            if (Height > 0) style.Add(string.Format("height={0}", Height));
            if (!ToolBar) style.Add(string.Format("toolbar={0}", 0));
            if (!Location) style.Add(string.Format("location={0}", 0));
            if (!Directories) style.Add(string.Format("directories={0}", 0));
            if (!Status) style.Add(string.Format("status={0}", 0));
            if (Scrollbars) style.Add(string.Format("scrollbars={0}", 1));
            style.Add(string.Format("resizable={0}", Resizable ? 1 : 0));

            return string.Join(",", style.ToArray());
        }
    }
}
